/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore;

import com.itayfeder.gelato_galore.GelatoGaloreConfig;
import com.itayfeder.gelato_galore.data.GelatoRecipesGen;
import com.itayfeder.gelato_galore.data.advancements.GelatoGaloreAdvancements;
import com.itayfeder.gelato_galore.data.tags.GelatoBlockTagsGen;
import com.itayfeder.gelato_galore.data.tags.GelatoItemTagsGen;
import com.itayfeder.gelato_galore.data.tags.GelatoPoiTypeTagsGen;
import com.itayfeder.gelato_galore.init.BlockEntityTypeInit;
import com.itayfeder.gelato_galore.init.BlockInit;
import com.itayfeder.gelato_galore.init.EntityTypeInit;
import com.itayfeder.gelato_galore.init.ItemInit;
import com.itayfeder.gelato_galore.init.RecipeInit;
import com.itayfeder.gelato_galore.init.villager.PoiTypeInit;
import com.itayfeder.gelato_galore.init.villager.ProfessionInit;
import com.itayfeder.gelato_galore.networking.SyncFlavorDataMessage;
import com.itayfeder.gelato_galore.toppings.Toppings;
import com.itayfeder.gelato_galore.utils.CauldronInter;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="gelato_galore")
public class GelatoGalore {
    public static final String MODID = "gelato_galore";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("gelato_galore", "gelato_galore")).serverAcceptedVersions(status -> true).clientAcceptedVersions(status -> true).networkProtocolVersion(() -> "1").simpleChannel();
    private static int messageID = 0;

    public GelatoGalore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ItemInit.ITEMS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        BlockEntityTypeInit.BLOCK_ENTITY_TYPES.register(modEventBus);
        ItemInit.CREATIVE_MODE_TABS.register(modEventBus);
        EntityTypeInit.ENTITY_TYPES.register(modEventBus);
        RecipeInit.RECIPE_SERIALIZERS.register(modEventBus);
        ProfessionInit.VILLAGER_PROFESSIONS.register(modEventBus);
        PoiTypeInit.POI_TYPES.register(modEventBus);
        GelatoGaloreConfig.register();
        Toppings.Init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::serverSetup);
        modEventBus.addListener(this::dataSetup);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture registries = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        GelatoBlockTagsGen blockTagsProvider = (GelatoBlockTagsGen)generator.addProvider(event.includeServer(), (DataProvider)new GelatoBlockTagsGen(output, registries, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GelatoItemTagsGen(output, registries, blockTagsProvider.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GelatoPoiTypeTagsGen(output, registries));
        generator.addProvider(includeServer, (DataProvider)new GelatoRecipesGen(output));
        generator.addProvider(includeServer, (DataProvider)new ForgeAdvancementProvider(output, registries, fileHelper, List.of(new GelatoGaloreAdvancements())));
    }

    private void serverSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ProfessionInit.fillTradeData());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        GelatoGalore.addMessage(SyncFlavorDataMessage.class, SyncFlavorDataMessage::toBytes, SyncFlavorDataMessage::new, SyncFlavorDataMessage::handle);
        CauldronInter.register();
    }

    public static <M> void addMessage(Class<M> messageType, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.messageBuilder(messageType, messageID, NetworkDirection.PLAY_TO_CLIENT).encoder(encoder).decoder(decoder).consumerMainThread(messageConsumer).add();
        System.out.println("REGISTERED MESSAGE: " + messageType.getName());
        ++messageID;
    }
}

